<?php
require 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: admin_login.php');
    exit;
}
function get_cached_tokens($url, $cachefile, $lifetime) {
    if (file_exists($cachefile) && (time() - filemtime($cachefile) < $lifetime)) {
        return file_get_contents($cachefile);
    } else {
        $csv = @file_get_contents($url);
        if ($csv) {
            file_put_contents($cachefile, $csv);
            return $csv;
        } elseif (file_exists($cachefile)) {
            return file_get_contents($cachefile);
        } else {
            return false;
        }
    }
}
$csv = get_cached_tokens($sheet_url_disney, $cache_file_disney, $cache_lifetime);
$lines = explode("\n", $csv ?: '');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel Disney+</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
</head>
<body>
<div class="container">
    <h2>Admin - Token List Disney+</h2>
    <a class="button-link" href="logout.php">Logout</a>
    <a class="button-link" href="history_disney.php">Lihat History Disney+</a>
    <form method="GET" style="display:inline;">
        <button type="submit" name="refresh" value="1">Force Refresh Token Disney+</button>
    </form>
    <br><br>
    <table id="adminTable" class="display">
        <thead><tr><th>Email</th><th>Token</th><th>Cek Kode</th></tr></thead>
        <tbody>
        <?php
        foreach ($lines as $line):
            $columns = str_getcsv($line);
            if (count($columns) >= 3 && !empty(trim($columns[1]))):
                $email = trim($columns[1]);
                $token = trim($columns[2]);
                $link = "mail_disney.php?email=" . urlencode($email) . "&token=" . urlencode($token);
        ?>
        <tr>
            <td><?= htmlspecialchars($email) ?></td>
            <td><?= htmlspecialchars($token) ?></td>
            <td><a class="button-link" href="<?= $link ?>" target="_blank">Cek Kode Disney+</a></td>
        </tr>
        <?php endif; endforeach; ?>
        </tbody>
    </table>
</div>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script>
$(document).ready(function() {
    $('#adminTable').DataTable();
});
</script>
</body>
</html>