<?php
require 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: admin_login.php');
    exit;
}
$history = [];
if (file_exists('logs/otp_history.csv')) {
    $lines = file('logs/otp_history.csv', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach (array_slice($lines, 1) as $line) {
        $columns = str_getcsv($line);
        if (count($columns) >= 3) {
            $history[] = $columns;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>History OTP Netflix</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
</head>
<body>
<div class="container">
    <h2>History OTP Netflix</h2>
    <a class="button-link" href="admin.php">← Kembali ke Admin Netflix</a>
    <br><br>
    <?php if (empty($history)): ?>
        <p>Belum ada OTP yang tercatat.</p>
    <?php else: ?>
    <table id="historyTable" class="display">
        <thead>
            <tr><th>Tanggal</th><th>Email</th><th>Kode</th></tr>
        </thead>
        <tbody>
            <?php foreach ($history as $row): ?>
            <tr>
                <td><?= htmlspecialchars($row[0]) ?></td>
                <td><?= htmlspecialchars($row[1]) ?></td>
                <td><?= htmlspecialchars($row[2]) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php endif; ?>
</div>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script>
$(document).ready(function() {
    $('#historyTable').DataTable();
});
</script>
</body>
</html>