<?php
require 'config.php';

function get_cached_tokens($url, $cachefile, $lifetime) {
    if (file_exists($cachefile) && (time() - filemtime($cachefile) < $lifetime)) {
        return file_get_contents($cachefile);
    } else {
        $csv = @file_get_contents($url);
        if ($csv) {
            file_put_contents($cachefile, $csv);
            return $csv;
        } elseif (file_exists($cachefile)) {
            return file_get_contents($cachefile);
        } else {
            return false;
        }
    }
}

$csv = get_cached_tokens($sheet_url_netflix, $cache_file, $cache_lifetime);
$lines = explode("\n", $csv ?: '');
$data = [];
foreach ($lines as $line) {
    $columns = str_getcsv($line);
    if (count($columns) >= 3) {
        $email = trim($columns[1]);
        $token = trim($columns[2]);
        $data[$email] = $token;
    }
}

if (!isset($_GET['email'], $_GET['token']) || !isset($data[$_GET['email']]) || $data[$_GET['email']] !== $_GET['token']) {
    die("Akses tidak diizinkan.");
}

$filter_email = $_GET['email'];
$inbox = imap_open($imap_server, $email_user, $email_pass) or die('Cannot connect to Mail: ' . imap_last_error());
$emails = imap_search($inbox, 'TO "' . $filter_email . '"');

$data_inbox = [];
$allowed_subjects = [
    "Netflix: Kode masukmu",
    "Netflix: Your sign-in code",
    "Netflix: Tu código de acceso",
    "Netflix: サインインコード",
    "Netflix: Votre code d’accès",
    "Netflix: Dein Zugangscode",
    "Netflix: Il tuo codice di accesso",
    "Netflix: Din adgangskode",
];

if ($emails) {
    rsort($emails);
    foreach ($emails as $email_number) {
        $overview = imap_fetch_overview($inbox, $email_number, 0)[0];
        foreach ($allowed_subjects as $allowed) {
            if (strpos($overview->subject, $allowed) !== false) {
                $message = imap_fetchbody($inbox, $email_number, 1);
                preg_match('/\b\d{4}\b/', $message, $matches);
                $kode = $matches[0] ?? null;
                if ($kode) {
                    $email_date = strtotime($overview->date);
                    if (time() - $email_date <= 15 * 60) {
                        $data_inbox[] = [
                            'date' => date('Y-m-d H:i:s', $email_date),
                            'code' => $kode
                        ];
                        if (!file_exists('logs/otp_history.csv')) {
                            file_put_contents('logs/otp_history.csv', "Tanggal,Email,Kode\n");
                        }
                        file_put_contents('logs/otp_history.csv', date('Y-m-d H:i:s', $email_date) . ",$filter_email,$kode\n", FILE_APPEND);
                    }
                }
                break;
            }
        }
        if (count($data_inbox) >= 10) {
            break;
        }
    }
}

imap_close($inbox);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Daftar Kode Masuk Netflix</title>
    <link rel="stylesheet" href="style.css">
    <script>
        var timeleft = 5;
        var downloadTimer = setInterval(function(){
            document.getElementById("countdown").innerHTML = timeleft + " detik";
            timeleft -= 1;
            if(timeleft < 0){
                clearInterval(downloadTimer);
                location.reload();
            }
        }, 1000);
    </script>
</head>
<body>
<div class="container">
    <h2>Daftar Kode Masuk Netflix: <?= htmlspecialchars($filter_email) ?></h2>
    <p>Auto refresh dalam: <span id="countdown">5 detik</span></p>
    <?php if (empty($data_inbox)): ?>
        <p>Tidak ada kode terbaru.</p>
    <?php else: ?>
        <ul>
            <?php foreach ($data_inbox as $item): ?>
                <li><?= htmlspecialchars($item['date']) ?> - <b><?= htmlspecialchars($item['code']) ?></b></li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>
</body>
</html>
