<?php
require 'config.php';

if (!isset($_GET['email'])) {
    die("Akses tidak diizinkan: Email tidak diberikan.");
}

$filter_email = $_GET['email'];

$inbox = imap_open($imap_server, $email_user, $email_pass) or die('Cannot connect to Mail: ' . imap_last_error());

$emails = imap_search($inbox, 'TO "' . $filter_email . '"');

$data_inbox = [];

$allowed_subjects = [
    "Penting: Cara mengonfirmasi perangkat Netflix-mu.",
    "Kode akses sementara Netflix-mu",
    "Your Netflix temporary access code",
    "Penting: Cara memperbarui Rumah dengan Akun Netflix-mu",
    "Important: How to update your Netflix Household"
];

function normalize_subject($text) {
    // Hapus karakter non-breaking space, tab, newline, dll.
    $text = trim($text);
    $text = preg_replace('/\x{00A0}/u', ' ', $text); // ganti non-breaking space dengan spasi normal
    $text = preg_replace('/\s+/u', ' ', $text);      // normalisasi spasi berlebih
    return $text;
}


if ($emails) {
    rsort($emails);
    foreach ($emails as $email_number) {
        $overview = imap_fetch_overview($inbox, $email_number, 0)[0];
        $email_date = $overview->udate ?? strtotime($overview->date);
        $subject = normalize_subject(iconv_mime_decode($overview->subject, 0, 'UTF-8'));
        
        

        if (time() - $email_date <= 15 * 60) { // 15 menit terakhir
            $message = imap_fetchbody($inbox, $email_number, 1); // Plain text part
            $message = quoted_printable_decode($message); // Decode =3D, dll

            foreach ($allowed_subjects as $allowed_subject) {
                if (stripos($subject, normalize_subject($allowed_subject)) !== false) {

                    preg_match_all('/\[(https?:\/\/[^\]]+)\]/i', $message, $link_matches);
                    $filtered_links = [];

                    foreach ($link_matches[1] as $link_candidate) {
                        if (stripos($link_candidate, 'travel/verify') !== false || stripos($link_candidate, 'update-primary-location') !== false || stripos($link_candidate, 'confirmdevice') !== false) {
                            $filtered_links[] = $link_candidate;
                        }
                    }
                    
                    $link = $filtered_links[0] ?? '';

                    if ($link) {
                        $data_inbox[] = [
                            'date' => date('Y-m-d H:i:s', $email_date),
                            'link' => $link
                        ];
                    }
                    break;
                }
            }
        }
        if (count($data_inbox) >= 10) {
            break;
        }
    }
}


imap_close($inbox);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Daftar Link Household Netflix</title>
    <link rel="stylesheet" href="style.css?v=2">
    <script>
        var timeleft = 5;
        var downloadTimer = setInterval(function(){
            document.getElementById("countdown").innerHTML = timeleft + " detik";
            timeleft -= 1;
            if(timeleft < 0){
                clearInterval(downloadTimer);
                location.reload();
            }
        }, 1000);
    </script>
</head>
<body>
<div class="container">
    
    <h2>Daftar Link Household Netflix: <?= htmlspecialchars($filter_email) ?></h2>
    
    
    <p>Auto refresh dalam: <span id="countdown">5 detik</span></p>
    <?php if (empty($data_inbox)): ?>
        <p>Tidak ada link terbaru.</p>
    <?php else: ?>
        <ul>
            <?php foreach ($data_inbox as $item): ?>
                <li>
                    <?= htmlspecialchars($item['date']) ?><br>
                    <b><a href="<?= htmlspecialchars($item['link']) ?>" target="_blank">🔗 Buka Link</a></b>
                </li><br>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>
</body>
</html>
