<?php
require 'config.php';

function get_cached_tokens($sheet_url, $cache_file, $cache_lifetime) {
    if (file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_lifetime)) {
        return file_get_contents($cache_file);
    } else {
        $csv = @file_get_contents($sheet_url);
        if ($csv) {
            file_put_contents($cache_file, $csv);
            return $csv;
        } elseif (file_exists($cache_file)) {
            return file_get_contents($cache_file);
        } else {
            return false;
        }
    }
}

// Daftar subject login dari Netflix berbagai bahasa
$allowed_subjects = [
    "Netflix: Kode masukmu", // Indonesia
    "Netflix: Your sign-in code", // English
    "Netflix: Tu código de acceso", // Spanish
    "Netflix: サインインコード", // Japanese
    "Netflix: Votre code d’accès", // French
    "Netflix: Dein Zugangscode", // German
    "Netflix: Il tuo codice di accesso", // Italian
    "Netflix: Din adgangskode", // Danish
];

$csv = get_cached_tokens($sheet_url, $cache_file, $cache_lifetime);
if (!$csv) {
    die("Gagal mengambil data token.");
}

$lines = explode("\n", $csv);
$data = [];
foreach ($lines as $line) {
    $columns = str_getcsv($line);
    if (count($columns) >= 3) {
        $email = trim($columns[1]);
        $token = trim($columns[2]);
        $data[$email] = $token;
    }
}

if (!isset($_GET['email'], $_GET['token']) || !isset($data[$_GET['email']]) || $data[$_GET['email']] !== $_GET['token']) {
    die("Akses tidak diizinkan.");
}

$filter_email = $_GET['email'];
$inbox = imap_open($imap_server, $email_user, $email_pass) or die('Cannot connect to Mail: ' . imap_last_error());
$emails = imap_search($inbox, 'TO "' . $filter_email . '"');

$data_inbox = [];

if ($emails) {
    rsort($emails);
    foreach ($emails as $email_number) {
        $overview = imap_fetch_overview($inbox, $email_number, 0)[0];
        foreach ($allowed_subjects as $allowed) {
            if (strpos($overview->subject, $allowed) !== false) {
                $message = imap_fetchbody($inbox, $email_number, 1);
                preg_match('/\b\d{4}\b/', $message, $matches);
                $kode = $matches[0] ?? null;
                if ($kode) {
                    $email_date = strtotime($overview->date);
                    if (time() - $email_date <= 15 * 60) {
                        $data_inbox[] = [
                            'date' => date('Y-m-d H:i:s', $email_date),
                            'code' => $kode
                        ];
                    }
                }
                break;
            }
        }
        if (count($data_inbox) >= 10) {
            break;
        }
    }
}

imap_close($inbox);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Daftar Kode Netflix</title>
    <link rel="stylesheet" href="style.css">
    <meta http-equiv="refresh" content="2">
</head>
<body>
<div class="container">
    <h2>Daftar Kode Netflix</h2>
    <?php if (empty($data_inbox)): ?>
        <p>Tidak ada kode terbaru.</p>
    <?php else: ?>
        <ul>
            <?php foreach ($data_inbox as $item): ?>
                <li><?= htmlspecialchars($item['date']) ?> - <b><?= htmlspecialchars($item['code']) ?></b></li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>

<!-- Histats.com  (div with counter) --><div id="histats_counter"></div>
<!-- Histats.com  START  (aync)-->
<script type="text/javascript">var _Hasync= _Hasync|| [];
_Hasync.push(['Histats.start', '1,4735553,4,511,95,18,00000000']);
_Hasync.push(['Histats.fasi', '1']);
_Hasync.push(['Histats.track_hits', '']);
(function() {
var hs = document.createElement('script'); hs.type = 'text/javascript'; hs.async = true;
hs.src = ('//s10.histats.com/js15_as.js');
(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(hs);
})();</script>
<noscript><a href="/" target="_blank"><img  src="//sstatic1.histats.com/0.gif?4735553&101" alt="" border="0"></a></noscript>
<!-- Histats.com  END  -->
</body>
</html>
