<?php
function randomAlamat($jumlah = 1000) {
    $jalanPrefixes = ["Jl.", "Jalan"];
    $namaJalan = [
        "Merdeka", "Sudirman", "Thamrin", "Gatot Subroto", "Rasuna Said",
        "Pondok Indah", "Kemang", "Daan Mogot", "Panjang", "TB Simatupang",
        "Kalimalang", "Ciputat", "Depok", "Bekasi Raya", "Margonda", "Serpong"
    ];
    $kelurahan = [
        "Cilandak", "Kebayoran Baru", "Menteng", "Tebet", "Cempaka Putih",
        "Pondok Cabe", "Cinere", "Beji", "Jatiasih", "Pondok Gede",
        "Serpong Utara", "BSD", "Pamulang", "Kalideres", "Cakung", "Pasar Minggu"
    ];
    $kecamatan = [
        "Cilandak", "Kebayoran Lama", "Setiabudi", "Pasar Rebo", "Sawangan",
        "Tebet", "Pancoran", "Cipayung", "Cibinong", "Tambun Selatan",
        "Cikarang Barat", "Ciledug", "Serpong", "Curug", "Karawaci", "Jatinegara"
    ];
    $kota = [
        "Jakarta Selatan", "Jakarta Timur", "Jakarta Barat", "Depok",
        "Bekasi", "Tangerang", "Tangerang Selatan", "Bogor"
    ];
    $jenisTempat = [
        "Apartemen", "Gedung", "Ruko", "Kantor", "Perumahan", "Cluster", "Villa", "Komplek"
    ];
    $namaTempat = [
        "Green Park", "Senayan Residence", "The Mansion", "Sky Tower", "Permata Hijau",
        "Grand Metropolitan", "Nusantara Office", "Bella Casa", "Graha Indah", "Citra Land",
        "Menara Prima", "Mega Kuningan", "Puri Indah", "Alam Sutera", "Bintaro Jaya"
    ];

    $alamatList = [];
    for ($i = 0; $i < $jumlah; $i++) {
        $prefix = $jalanPrefixes[array_rand($jalanPrefixes)];
        $nama = $namaJalan[array_rand($namaJalan)];
        $nomor = "No. " . rand(1, 200);
        $rt = "RT " . str_pad(rand(1, 10), 2, '0', STR_PAD_LEFT);
        $rw = "RW " . str_pad(rand(1, 10), 2, '0', STR_PAD_LEFT);
        $kel = $kelurahan[array_rand($kelurahan)];
        $kec = $kecamatan[array_rand($kecamatan)];
        $city = $kota[array_rand($kota)];
        $kode = rand(10110, 17560);

        $tipe = $jenisTempat[array_rand($jenisTempat)];
        $namaGedung = $namaTempat[array_rand($namaTempat)];
        $unit = "Unit " . chr(rand(65, 90)) . rand(1, 20); // contoh: Unit B7

        $alamat = "$tipe $namaGedung, $unit, $prefix $nama $nomor, $rt/$rw, Kel. $kel, Kec. $kec, $city, $kode";
        $alamatList[] = $alamat;
    }

    return $alamatList;
}

$alamatJabodetabek = randomAlamat(1000);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Daftar Alamat Jabodetabek Lengkap</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        table { border-collapse: collapse; width: 100%; font-size: 14px; }
        th, td { border: 1px solid #ccc; padding: 6px; text-align: left; }
    </style>
</head>
<body>
    <h2>1000 Alamat Jabodetabek (Versi Lengkap)</h2>
    <table>
        <tr><th>No</th><th>Alamat</th></tr>
        <?php foreach ($alamatJabodetabek as $i => $alamat): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td><?= htmlspecialchars($alamat) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
