<?php

require_once "config.php";   // Berisi API Key Fonnte atau config lain
require_once "library.php";  // Berisi fungsi sendFonnte()

$secret = 'D1g1flzzWebhook2025'; // Secret yang disetting di dashboard Digiflazz

// Ambil body asli dari request
$post_data = file_get_contents('php://input');

// Ambil header dari request
$headers = getallheaders();
$received_signature = $headers['X-Hub-Signature'] ?? ($_SERVER['HTTP_X_HUB_SIGNATURE'] ?? '');


// Buat signature lokal untuk dicocokkan
$expected_signature = 'sha1=' . hash_hmac('sha1', $post_data, $secret);

// Decode payload
$payload = json_decode($post_data, true);

// Logging umum (semua ping dan transaksi)
file_put_contents('webhook-log.txt', json_encode([
    'expected_signature' => $expected_signature,
    'received_signature' => $received_signature,
    'body' => $payload
], JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);

// Jika ini transaksi (bukan ping)
if (isset($payload['data']['ref_id'])) {

    $ref_id  = $payload['data']['ref_id'];
    $status  = $payload['data']['status'];
    $message = $payload['data']['message'];
    $sn = $payload['data']['sn'];

    // Validasi signature
    if (hash_equals($expected_signature, $received_signature)) {

        // Simpan log transaksi
        file_put_contents('transaksi-log.txt', json_encode([
            'ref_id' => $ref_id,
            'status' => $status,
            'message' => $message,
            'sn' => $sn,
            'timestamp' => date("Y-m-d H:i:s")
        ], JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);

        // Kirim notifikasi ke Fonnte
        $chat_id = "120363232763862278@g.us"; // ID Grup WA / nomor tujuan
        $reply = [
	        "message" => "🔔 Status Transaksi\nRef ID: $ref_id\nStatus: $status\nPesan: $message\nSN: $sn",
        ];  
 
        sendFonnte($chat_id, $reply);

        // Wajib balas ke Digiflazz
        echo json_encode(["rc" => "00"]);
        exit;
    } else {
        http_response_code(403);
        echo json_encode(["rc" => "99", "message" => "Unauthorized Signature"]);
        exit;
    }

} elseif (isset($payload['sed'])) {
    // Ini ping
    file_put_contents('ping-log.txt', json_encode($payload, JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);
    echo json_encode(["rc" => "00"]);
    exit;
} else {
    // Format tidak dikenali
    http_response_code(400);
    echo json_encode(["rc" => "99", "message" => "Invalid Payload"]);
    exit;
}
