<?php
require 'config.php';

if (!isset($_GET['password']) || $_GET['password'] !== $admin_password) {
    die("Unauthorized access.");
}

function refresh_tokens($sheet_url, $cache_file) {
    $csv = @file_get_contents($sheet_url);
    if ($csv) {
        file_put_contents($cache_file, $csv);
        return true;
    }
    return false;
}

if (isset($_GET['refresh'])) {
    refresh_tokens($sheet_url, $cache_file);
    header("Location: admin.php?password=" . urlencode($admin_password));
    exit;
}

$csv = file_exists($cache_file) ? file_get_contents($cache_file) : '';
$lines = explode("\n", $csv);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2>Admin - Token List</h2>
    <p>Last cache update: <?= file_exists($cache_file) ? date('Y-m-d H:i:s', filemtime($cache_file)) : 'No cache' ?></p>
    <form method="GET">
        <input type="hidden" name="password" value="<?= htmlspecialchars($admin_password) ?>">
        <button type="submit" name="refresh" value="1">Force Refresh Data</button>
    </form>
    <br>
    <table>
        <tr><th>Email</th><th>Token</th></tr>
        <?php foreach ($lines as $line): 
            $columns = str_getcsv($line);
            if (count($columns) >= 3): ?>
            <tr>
                <td><?= htmlspecialchars($columns[1]) ?></td>
                <td><?= htmlspecialchars($columns[2]) ?></td>
            </tr>
        <?php endif; endforeach; ?>
    </table>
</div>
</body>
</html>
